/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.bclib.api.v3.datagen.DropSelfLootProvider;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.betternether.blockentities.BlockEntityFurnace;
import org.betterx.betternether.registry.BlockEntitiesRegistry;

public class BlockNetherFurnace
extends AbstractFurnaceBlock
implements BehaviourStone,
DropSelfLootProvider<BlockNetherFurnace> {
    public BlockNetherFurnace(Block source) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)source).m_60999_().m_60953_(BlockNetherFurnace::getLuminance));
    }

    private static int getLuminance(BlockState blockState) {
        return blockState.m_61145_((Property)BlockStateProperties.f_61443_).orElse(false) != false ? 13 : 0;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BlockEntityFurnace(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return BlockNetherFurnace.m_151987_((Level)world, type, BlockEntitiesRegistry.NETHERRACK_FURNACE);
    }

    protected void m_7137_(Level world, BlockPos pos, Player player) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof BlockEntityFurnace) {
            player.m_5893_((MenuProvider)blockEntity);
            player.m_36220_(Stats.f_12966_);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)f_48684_)).booleanValue()) {
            double d = (double)pos.m_123341_() + 0.5;
            double e = pos.m_123342_();
            double f = (double)pos.m_123343_() + 0.5;
            if (random.m_188500_() < 0.1) {
                world.m_7785_(d, e, f, SoundEvents.f_11907_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            Direction direction = (Direction)state.m_61143_((Property)f_48683_);
            Direction.Axis axis = direction.m_122434_();
            double h = random.m_188500_() * 0.6 - 0.3;
            double i = axis == Direction.Axis.X ? (double)direction.m_122429_() * 0.52 : h;
            double j = random.m_188500_() * 6.0 / 16.0;
            double k = axis == Direction.Axis.Z ? (double)direction.m_122431_() * 0.52 : h;
            world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d + i, e + j, f + k, 0.0, 0.0, 0.0);
            world.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d + i, e + j, f + k, 0.0, 0.0, 0.0);
        }
    }
}

